function P81_iv
% Problem 8.1 :	Nonlinear parametric pendulum
% Part iv. Sensitive dependence on initial conditions

% Define some constants
omega0=1;       % Natural frequency of the pendulum
gamma=0.1;      % Damping coefficient
h=2.20;         % Amplitude of forcing 

% Define some parameters for using Runge-Kutta metod
tspan=[0 500];      % Time span to be obtained
theta0=[1e-1,0];    % Initial conditions
dtheta0=[0,1e-8];   % Change of initial conditions

% Choose time step smaller than 0.01 sec
optn=odeset('InitialStep',1e-2,'MaxStep',1e-2);

% Simulation with given initial condition
[T,Y]=ode45(@(t,x) Npp(t,x,gamma,omega0,h),tspan,theta0,optn);
% Simulation with given initial condition + delta
[Td,Yd]=ode45(@(t,x) Npp(t,x,gamma,omega0,h),tspan,theta0+dtheta0,optn);
% Generate figure
figure(1); 
% Plot steady state response for given h
subplot(2,1,1); plot(T,Y(:,1),'r-',Td,Yd(:,1),'b--');
grid on; axis tight;
xlabel('\bfTime (second)');
ylabel('\bfAngular Position \theta (rad)');
title('\bfSteady State Response (t,\theta)');
legend('\bf\theta_0','\bf\theta_0+\delta\theta', ...
    'Location','NorthWest');
subplot(2,1,2); plot(T,Y(:,2),'r-',Td,Yd(:,2),'b--');
grid on; axis tight;
xlabel('\bfTime (second)');
ylabel('\bfAngular Velocity d\theta/dt (rad/sec)');
title('\bfResponse (t,d\theta/dt) with different initial conditions');    
legend('\bf\theta_0','\bf\theta_0+\delta\theta', ...
    'Location','SouthWest');

% Plot phase space
% Use mod for the angular position (-pi<=theta<=+pi)
figure(2);
p=plot(pi-mod(Y(:,1),2*pi),Y(:,2),'ro', ...
    pi-mod(Yd(:,1),2*pi),Yd(:,2),'bs');
set(p,'MarkerSize',1);
grid on; axis tight;
xlabel('\bfAngular Position \theta (rad)');
ylabel('\bfAngular Velocity d\theta/dt(rad/sec)');
title('\bfPhase Space (\theta,d\theta/dt)');
legend('\bf\theta_0','\bf\theta_0+\delta\theta', ...
    'Location','SouthWest');
end

function dx=Npp(t,x,gamma,omega0,h)
% Describe nonlinear parametric pendulum motion
dx(1,1)=x(2);
dx(2,1)=-2*gamma*x(2)-omega0^2*(1+h*cos(2*omega0*t))*sin(x(1));
end